module net.BurtonRadons.spyl.expressionAssign;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.expressionBinary;
private import net.BurtonRadons.spyl.expressionSymbol;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** Assign a value to a parameter; "a = b". */
class AssignExpression : BinaryExpression
{
    /** This is not a supported form for an assignment expression. */
    class AssignFormError : Error
    {
        Expression expression; /**< The expression that failed. */
        
        this (Expression expression)
        {
            this.expression = expression;
            super (expression.toString () ~ " is not a supported form for an assignment expression.");
        }
    }
    
    /** Assign the parameters. */
    this (Mark mark, Expression a, Expression b)
    {
        super (mark, a, b);
    }
    
    char [] operatorName ()
    {
        return "=";
    }
    
    override char [] toString ()
    {
        return subString (a) ~ " " ~ operatorName () ~ " " ~ subString (b);
    }
    
    Value result (Scope scope)
    {
        return b.evaluate (scope);
    }
    
    override Value evaluate (Scope scope)
    {
        Value result = this.result (scope);
        
        if (cast (SymbolExpression) a)
            evaluateSymbol (scope, cast (SymbolExpression) a, result);
        else
            throw new AssignFormError (a);
            
        return result;
    }
    
    /** Evaluate for an lvalue of a symbol expression. */
    void evaluateSymbol (Scope scope, SymbolExpression a, Value b)
    {
        scope.assign (a.name, b);
    }
    
    override int precedence ()
    {
        return Precedence.Assign;
    }
}

/** Catenate and assign; "a ~= b". */
class CatenateAssignExpression : AssignExpression
{
    /** Assign the parameters. */
    this (Mark mark, Expression a, Expression b)
    {
        super (mark, a, b);
    }
    
    override char [] operatorName ()
    {
        return "~=";
    }
    
    override Value result (Scope scope)
    {
        return a.evaluate (scope).catass (b.evaluate (scope));
    }
}